% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_grid.R
\name{hier_grid}
\alias{hier_grid}
\title{Compute a grid given different hierarchies}
\usage{
hier_grid(..., add_dups = TRUE, add_levs = FALSE)
}
\arguments{
\item{...}{one or more hierarchy objects created with \code{\link[=hier_create]{hier_create()}} or
\code{\link[=hier_compute]{hier_compute()}}}

\item{add_dups}{scalar logical defining if bogus codes (codes that are the only
leaf contributing to a parent that also has no siblings) should be included.}

\item{add_levs}{scalar logical defining if numerical levels for each codes should
be appended to the output \code{data.table}.}
}
\value{
a \code{data.table} featuring a column for each hierarchy object specified in
argument \code{...}. These columns are labeled \code{v{n}}. If \code{add_levs} is \code{TRUE},
for each hierarchy provided, an additional column labeled \code{levs_v{n}} is appended
to the output. Its values define the hierarchy level of the corresponding code
given in \code{v{n}} in the same row.
}
\description{
This function returns a \code{data.table} containing all possible combinations of
codes from at least one hierarchy object. This is useful to compute a \emph{"complete"}
table from several hierarchies.
}
\examples{
# define some hierarchies with some "duplicates" or "bogus" codes
h1 <- hier_create("Total", nodes = LETTERS[1:3])
h1 <- hier_add(h1, root = "A", node = "a1")
h1 <- hier_add(h1, root = "a1", node = "aa1")

h2 <- hier_create("Total", letters[1:5])
h2 <- hier_add(h2, root = "b", node = "b1")
h2 <- hier_add(h2, root = "d", node = "d1")

# with all codes, also "bogus" codes
hier_grid(h1, h2)

# only the required codes to build the complete hierarchy (no bogus codes)
hier_grid(h1, h2, add_dups = FALSE)

# also contain columns specifying the hierarchy level
hier_grid(h1, h2, add_dups = FALSE, add_levs = TRUE)
}
