\docType{class}
\name{problemInstance-class}
\alias{problemInstance-class}
\title{S4 class describing a problemInstance-object}
\description{
An object of class \code{problemInstance} holds the main
information that is required to solve the secondary cell
suppression problem.
}
\details{
\describe{ \item{slot \code{strID}:}{a character vector (or
NULL) of ID's identifying table cells} \item{slot
\code{Freq}:}{a numeric vector (or NULL) of counts for each
table cell} \item{slot \code{w}:}{a numeric vector (or
NULL) of weights that should be used when solving the
secondary cell suppression problem } \item{slot
\code{numVars}:}{a list (or NULL) with each element being a
numeric vector holding values of specified numerical
variables for each table cell} \item{slot
\code{lb}:}{numeric vector (or NULL) holding assumed lower
bounds for each table cell} \item{slot \code{ub}:}{numeric
vector (or NULL) holding assumed upper bounds for each
table cell} \item{slot \code{LPL}:}{numeric vector (or
NULL) holding required lower protection levels for each
table cell} \item{slot \code{UPL}:}{numeric vector (or
NULL) holding required upper protection levels for each
table cell} \item{slot \code{SPL}:}{numeric vector (or
NULL) holding required sliding protection levels for each
table cell} \item{slot \code{sdcStatus}:}{character vector
(or NULL) holding the current anonymization state for each
cell. \itemize{ \item \code{z}: cell is forced to be
published and must not be suppressed \item \code{u}: cell
has been primary suppressed \item \code{x}: cell is a
secondary suppression \item \code{s}: cell can be
published} }}
}
\note{
objects of class \code{problemInstance} are used as input
for slot \code{problemInstance} in class \code{sdcProblem}
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

