% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra-optimization.R
\name{run_extra_optimization}
\alias{run_extra_optimization}
\title{Run extra optimization on an already fitted object}
\usage{
run_extra_optimization(object, nlminb_loops = 0, newton_loops = 1)
}
\arguments{
\item{object}{An object from \code{\link[=sdmTMB]{sdmTMB()}}.}

\item{nlminb_loops}{How many extra times to run \code{\link[stats:nlminb]{stats::nlminb()}}
optimization. Sometimes restarting the optimizer at the previous best
values aids convergence.}

\item{newton_loops}{How many extra Newton optimization loops to try with
\code{\link[stats:optim]{stats::optimHess()}}. Sometimes aids convergence.}
}
\value{
An updated model fit of class \code{sdmTMB}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{if (inla_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Run extra optimization steps to help convergence:
# (Not typically needed)
fit <- sdmTMB(density ~ 0 + poly(depth, 2) + as.factor(year),
  data = pcod_2011, mesh = pcod_mesh_2011, family = tweedie())
fit_1 <- run_extra_optimization(fit, newton_loops = 1)
max(fit$gradients)
max(fit_1$gradients)
\dontshow{\}) # examplesIf}
}
