% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxcut.R
\name{maxcut}
\alias{maxcut}
\title{Max-Cut Problem}
\usage{
maxcut(B)
}
\arguments{
\item{B}{A (weighted) adjacency matrix corresponding to a graph}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{maxcut} creates input for sqlp to solve the Max-Cut problem -
given a graph B, find the maximum cut of the graph
}
\details{
Determines the maximum cut for a graph B. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Bmaxcut)

out <- maxcut(Bmaxcut)

}
