% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdtm.oak-package.R
\docType{package}
\name{sdtm.oak-package}
\alias{sdtm.oak}
\alias{sdtm.oak-package}
\title{sdtm.oak: SDTM Data Transformation Engine}
\description{
An Electronic Data Capture system (EDC) and Data Standard agnostic solution that enables the pharmaceutical programming community to develop Clinical Data Interchange Standards Consortium (CDISC) Study Data Tabulation Model (SDTM) datasets in R. The reusable algorithms concept in 'sdtm.oak' provides a framework for modular programming and can potentially automate the conversion of raw clinical data to SDTM through standardized SDTM specifications. SDTM is one of the required standards for data submission to the Food and Drug Administration (FDA) in the United States and Pharmaceuticals and Medical Devices Agency (PMDA) in Japan. SDTM standards are implemented following the SDTM Implementation Guide as defined by CDISC \url{https://www.cdisc.org/standards/foundational/sdtmig}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pharmaverse.github.io/sdtm.oak/}
  \item Report bugs at \url{https://github.com/pharmaverse/sdtm.oak/issues/}
}

}
\author{
\strong{Maintainer}: Rammprasad Ganapathy \email{ganapathy.rammprasad@gene.com}

Authors:
\itemize{
  \item Adam Forys
  \item Edgar Manukyan
  \item Rosemary Li
  \item Preetesh Parikh
  \item Lisa Houterloot
  \item Yogesh Gupta
  \item Omar Garcia \email{ogcalderon@cdisc.org}
  \item Ramiro Magno \email{rmagno@pattern.institute} (\href{https://orcid.org/0000-0001-5226-3441}{ORCID})
  \item Kamil Sijko \email{kamil.sijko@ttsi.com.pl} (\href{https://orcid.org/0000-0002-2203-1065}{ORCID})
  \item Shiyu Chen \email{Shiyu.Chen@atorusresearch.com}
}

Other contributors:
\itemize{
  \item Pattern Institute [copyright holder, funder]
  \item F. Hoffmann-La Roche AG [copyright holder, funder]
  \item Pfizer Inc [copyright holder, funder]
  \item Transition Technologies Science [copyright holder, funder]
}

}
\keyword{internal}
