% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_outliers.R
\name{plot.see_check_outliers}
\alias{plot.see_check_outliers}
\title{Plot method for checking outliers}
\usage{
\method{plot}{see_check_outliers}(
  x,
  size_text = 3.5,
  linewidth = 0.8,
  size_title = 12,
  size_axis_title = base_size,
  base_size = 10,
  alpha_dot = 0.8,
  colors = c("#3aaf85", "#1b6ca8", "#cd201f"),
  rescale_distance = TRUE,
  type = c("dots", "bars"),
  show_labels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{linewidth}{Numeric value specifying size of line geoms.}

\item{base_size, size_axis_title, size_title}{Numeric value specifying size of
axis and plot titles.}

\item{alpha_dot}{Numeric value specifying alpha level of the point geoms.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) for points and line.}

\item{rescale_distance}{Logical. If \code{TRUE}, distance values are rescaled
to a range from 0 to 1. This is mainly due to better catch the differences
between distance values.}

\item{type}{Character vector, indicating the type of plot.
Options are \code{"dots"} (default) for a scatterplot of leverage (hat) values
versus residuals, with Cook's Distance contours for evaluating influential
points, or \code{"bars"} for a bar chart of (rescaled) outlier statistic values
for each data point. Only used for outlier plots of fitted models; for
outlier plots of raw data values, \code{type = "bars"} is always used.}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_outliers()}
function.
}
\examples{
library(performance)
data(mtcars)
mt1 <- mtcars[, c(1, 3, 4)]
mt2 <- rbind(
  mt1,
  data.frame(mpg = c(37, 40), disp = c(300, 400), hp = c(110, 120))
)
model <- lm(disp ~ mpg + hp, data = mt2)
plot(check_outliers(model))
}
