% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_flat.R
\name{scale_color_flat}
\alias{scale_color_flat}
\alias{scale_color_flat_d}
\alias{scale_color_flat_c}
\alias{scale_colour_flat}
\alias{scale_colour_flat_c}
\alias{scale_colour_flat_d}
\alias{scale_fill_flat}
\alias{scale_fill_flat_d}
\alias{scale_fill_flat_c}
\title{Flat UI color palette}
\usage{
scale_color_flat(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_flat_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_color_flat_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_flat(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_flat_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_colour_flat_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "color",
  ...
)

scale_fill_flat(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_flat_d(
  palette = NULL,
  discrete = TRUE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)

scale_fill_flat_c(
  palette = NULL,
  discrete = FALSE,
  reverse = FALSE,
  aesthetics = "fill",
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Depending on the color scale, can
be one of \code{"full"}, \code{"ice"}, \code{"rainbow"}, \code{"complement"}, \code{"contrast"},
\code{"light"} (for dark themes), \code{"black_first"}, \code{full_original}, or
\code{black_first_original}. The latter three options are especially for the
Okabe-Ito color palette. The default is \code{NULL} and either \code{"contrast"} or
\code{"gradient"} is used (depending on whether \code{discrete} is \code{TRUE} or \code{FALSE}),
which are the two scale useful for discrete or gradient color scales,
respectively.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{aesthetics}{A vector of names of the aesthetics that this scale
should be applied to (e.g., \code{c('color', 'fill')}).}

\item{...}{Additional arguments passed to \code{discrete_scale()} when \code{discrete}
is \code{TRUE} or to \code{scale_color_gradientn()} when \code{discrete} is \code{FALSE}.}
}
\description{
The palette based on \href{https://materialui.co/flatuicolors}{Flat UI}. Use
\code{scale_color_flat_d} for \emph{discrete} categories and \code{scale_color_flat_c} for a
\emph{continuous} scale, or use the \code{discrete} argument in \code{scale_color_flat()}.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_flat()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_flat(palette = "ice")

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_flat(discrete = FALSE)
}
