% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.n_factors.R
\name{plot.see_n_factors}
\alias{plot.see_n_factors}
\title{Plot method for numbers of clusters to extract or factors to retain}
\usage{
\method{plot}{see_n_factors}(x, data = NULL, type = c("bar", "line", "area"), size = 1, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{type}{Character vector, indicating the type of plot.}

\item{size}{Depending on \code{type}, a numeric value specifying size of bars,
lines, or segments.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::n_factors()} and \code{parameters::n_clusters()}
}
\examples{
if (require("parameters") && require("nFactors")) {
  data(mtcars)
  result <- n_factors(mtcars, type = "PCA")
  result
  plot(result, type = "line")
}
}
