% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_model.R
\name{N_model}
\alias{N_model}
\title{Analysis: graph for not significant trend}
\usage{
N_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  error = "SE",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  legend.position = "top"
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is "top")}
}
\value{
The function returns an exploratory graph of segments
}
\description{
Ggraph for non-significant trend. Can be used within the multicurve command
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
N_model(trat,resp)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{non-significant}
