% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{trimgalore}
\alias{trimgalore}
\title{Run Trim Galore!}
\usage{
trimgalore(
  filepaths,
  outputDir = "trimgalore_output",
  cmd = "trim_galore",
  args = NULL,
  pigzCmd = "pigz"
)
}
\arguments{
\item{filepaths}{Paths to fastq files. For single-end reads, each element
should be a single filepath. For paired-end reads, each element should be
two filepaths separated by ";".}

\item{outputDir}{Directory in which to store output. Will be created if it
doesn't exist.}

\item{cmd}{Name or path of the command-line interface.}

\item{args}{Additional arguments to pass to the command-line interface.
Output files will always be compressed. Arguments "--gzip", "--cores",
"-j", and "--basename" are not allowed. Arguments "-o" and "--paired"
should not be specified here.}

\item{pigzCmd}{String for pigz command, which will gzip the output files.}
}
\value{
A vector of exit codes, invisibly.
}
\description{
This function calls
\href{https://www.bioinformatics.babraham.ac.uk/projects/trim_galore/}{trim_galore}
using \code{\link[=system2]{system2()}}, and is only designed to handle standard adapter/quality
trimming. To run in parallel, register a parallel backend, e.g., using
\code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}.
}
\seealso{
\code{\link[=seeker]{seeker()}}
}
