% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual_expected.R
\name{mutual_expected}
\alias{mutual_expected}
\title{Calculate expected values when true segregation is zero}
\usage{
mutual_expected(
  data,
  group,
  unit,
  weight = NULL,
  fixed_margins = TRUE,
  n_bootstrap = 100,
  base = exp(1)
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{fixed_margins}{Should the margins be fixed or simulated? (Default \code{TRUE})}

\item{n_bootstrap}{Number of bootstrap iterations. (Default \code{100})}

\item{base}{Base of the logarithm that is used in the calculation.
Defaults to the natural logarithm.}
}
\value{
A data.table with two rows, corresponding to the expected values of
   segregation when true segregation is zero.
}
\description{
When sample sizes are small, one group has a small proportion, or
when there are many units, segregation indices are typically upwardly
biased, even when true segregation is zero. This function simulates
tables with zero segregation, given the marginals of the dataset,
and calculates segregation. If the expected values are large,
the interpretation of index scores might have to be adjusted.
}
\examples{
# the schools00 dataset has a large sample size, so expected segregation is close to zero
mutual_expected(schools00, "race", "school", weight = "n")

# but we can build a smaller table, with 100 students distributed across
# 10 schools, where one racial group has 10\% of the students
small <- data.frame(
          school = c(1:10, 1:10),
          race = c(rep("r1", 10), rep("r2", 10)),
          n = c(rep(1, 10), rep(9, 10)))
mutual_expected(small, "race", "school", weight= "n")
# with an increase in sample size (n=1000), the values improve
small$n <- small$n * 10
mutual_expected(small, "race", "school", weight= "n")
}
