% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_elements.R
\name{find_elements}
\alias{find_elements}
\alias{find_elements.selenider_session}
\alias{find_elements.selenider_element}
\title{Find multiple HTML child elements}
\usage{
find_elements(x, ...)

\method{find_elements}{selenider_session}(
  x,
  css = NULL,
  xpath = NULL,
  id = NULL,
  class_name = NULL,
  name = NULL,
  ...
)

\method{find_elements}{selenider_element}(
  x,
  css = NULL,
  xpath = NULL,
  id = NULL,
  class_name = NULL,
  name = NULL,
  ...
)
}
\arguments{
\item{x}{A selenider session or element.}

\item{...}{Arguments passed to methods.}

\item{css}{A css selector.}

\item{xpath}{An XPath.}

\item{id}{The id of the element you want to select.}

\item{class_name}{The class name of the element you want to select.}

\item{name}{The name attribute of the element you want to select.}
}
\value{
A \code{selenider_elements} object.
}
\description{
Find every available HTML element using a CSS selector, an XPath, or a
variety of other methods.
}
\details{
If more than one method is used to select an element (e.g. \code{css} and
\code{xpath}), the first element which satisfies every condition will be found.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div id='outer-div'>
  <div>
    <p>Text 1</p>
    <p>Text 2</p>
    <p>Text 3</p>
  </div>
</div>

<div></div>
"

session <- minimal_selenider_session(html)

session |>
  find_elements("div")

# Or:
ss("div")

session |>
  find_element("#outer-div") |>
  find_elements("p")

# The above can be shortened to:
s("#outer-div") |>
  find_elements("p")

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=ss]{ss()}} to quickly select multiple elements without specifying the session.
\item \code{\link[=find_element]{find_element()}} to select multiple elements.
\item \code{\link[=selenider_session]{selenider_session()}} to begin a session.
\item \code{\link[=elem_children]{elem_children()}} and family to select elements using their relative
position in the DOM.
\item \code{\link[=elem_filter]{elem_filter()}} and \code{\link[=elem_find]{elem_find()}} for filtering element collections.
}
}
