% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{reload}
\alias{reload}
\alias{refresh}
\title{Reload the current page}
\usage{
reload(timeout = 60, session = NULL)

refresh(timeout = 60, session = NULL)
}
\arguments{
\item{timeout}{The maximum time to wait for the page to load, in seconds.}

\item{session}{A \code{selenider_session} object. If not specified, the global
session object (the result of \code{\link[=get_session]{get_session()}}) is used.}
}
\value{
The session object, invisibly.
}
\description{
\code{reload()} and \code{refresh()} both reload the current page.
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session()

open_url("https://r-project.org")

reload()
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{current_url}()},
\code{\link{execute_js_fn}()},
\code{\link{get_page_source}()},
\code{\link{open_url}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
