% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{validateInput}
\alias{validateInput}
\title{validateInput}
\usage{
validateInput(
  power.type = NULL,
  effect = NULL,
  effect.measure = NULL,
  alpha = NULL,
  beta = NULL,
  power = NULL,
  abratio = NULL,
  N = NULL,
  df = NULL,
  p = NULL,
  SigmaHat = NULL,
  Sigma = NULL,
  muHat = NULL,
  mu = NULL,
  simulatedPower = FALSE,
  modelH0 = NULL,
  power.min = alpha,
  power.max = 0.999,
  effect.min = NULL,
  effect.max = NULL,
  steps = 50,
  linewidth = 1
)
}
\arguments{
\item{power.type}{type of power analyses, one of \code{"a-priori"}, \code{"post-hoc"}, \code{"compromise"}, \code{"powerplot.byN"}, \code{"powerplot.byEffect"}}

\item{effect}{effect size specifying the discrepancy between H0 and H1}

\item{effect.measure}{type of effect, one of \code{"F0"}, \code{"RMSEA"}, \code{"Mc"}, \code{"GFI"}, \code{"AGFI"}}

\item{alpha}{alpha error}

\item{beta}{beta error}

\item{power}{power (= 1 - beta)}

\item{abratio}{ratio alpha/beta}

\item{N}{the number of observations}

\item{df}{the model degrees of freedom}

\item{p}{the number of observed variables, required for \code{effect.measure = "GFI"} and \code{effect.measure = "AGFI"}}

\item{SigmaHat}{model implied covariance matrix}

\item{Sigma}{observed (or population) covariance matrix}

\item{muHat}{model implied mean vector}

\item{mu}{observed (or population) mean vector}

\item{simulatedPower}{whether to perform a simulated (\code{TRUE}) (rather than analytical, \code{FALSE}) power analysis.}

\item{modelH0}{for simulated power: \code{lavaan} model string defining the (incorrect) analysis model.}

\item{power.min}{for plotting: minimum power}

\item{power.max}{for plotting: maximum power}

\item{effect.min}{for plotting: minimum effect}

\item{effect.max}{for plotting: maximum effect}

\item{steps}{for plotting: number of sampled points}

\item{linewidth}{for plotting: linewidth}
}
\description{
Validates input for power functions.
}
