% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{genData.mnonr}
\alias{genData.mnonr}
\title{genData.mnonr}
\usage{
genData.mnonr(
  N = NULL,
  Sigma = NULL,
  nSets = 1,
  skewness = NULL,
  kurtosis = NULL
)
}
\arguments{
\item{N}{sample size.}

\item{Sigma}{population covariance matrix.}

\item{nSets}{number of data sets to generate}

\item{skewness}{multivariate skewness. May not be negative.}

\item{kurtosis}{multivariate kurtosis. Must be >= 1.641 skewness + p (p + 0.774), where p is the number of variables.}
}
\value{
Returns the generated data
}
\description{
Generates random data conforming to a population variance-covariance matrix using
the approach by Qu, Liu, & Zhang (2020) specifying Mardia's multivariate skewness and kurtosis.
}
\details{
This function is a wrapper for the respective function of the \code{mnonr} package.

For details, see
Qu, W., Liu, H., & Zhang, Z. (2020). A method of generating multivariate non-normal random numbers with desired multivariate skewness and kurtosis. \emph{Behavior Research Methods, 52}, 939-946. doi: 10.3758/s13428-019-01291-5
}
