% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_consistent.R
\name{PLSc}
\alias{PLSc}
\title{seminr PLSc Function}
\usage{
PLSc(seminr_model)
}
\arguments{
\item{seminr_model}{A \code{seminr_model} containing the estimated seminr model.}
}
\description{
The \code{PLSc} function calculates the consistent PLS path coefficients and loadings for
a common-factor model. It returns a \code{seminr_model} containing the adjusted and consistent
path coefficients and loadings for common-factor models and composite models.
}
\examples{
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

seminr_model <- estimate_pls(data = mobi,
                             measurement_model = mobi_mm,
                             structural_model = mobi_sm)

PLSc(seminr_model)
}
\references{
Dijkstra, T. K., & Henseler, J. (2015). Consistent Partial Least Squares Path Modeling, 39(X).
}
\seealso{
\code{\link{relationships}} \code{\link{constructs}} \code{\link{paths}} \code{\link{interaction_term}}
         \code{\link{bootstrap_model}}
}
