% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_interactions.R
\name{two_stage}
\alias{two_stage}
\title{Creates an interaction measurement item using a two-stage approach.
The two-stage procedure for both PLS and CBSEM models estimates construct 
scores in the first stage, and uses them to produce a single-item product 
item for the interaction term in the second stage.
For a PLS model, the first stage uses PLS to compute construct scores. 
For a CBSEM model, the first stage uses a CFA to produce ten Berge 
construct scores.}
\usage{
# two stage approach as per Henseler & Chin (2010):
 two_stage(iv, moderator, weights)
}
\arguments{
\item{iv}{The independent variable that is subject to moderation.}

\item{moderator}{The moderator variable.}

\item{weights}{is the relationship between the items and the interaction terms. This can be
specified as \code{correlation_weights} or \code{mode_A} for correlation weights (Mode A) or as
\code{regression_weights} or \code{mode_B} for regression weights (Mode B). Default is correlation weights.}
}
\description{
Creates an interaction measurement item using a two-stage approach.
The two-stage procedure for both PLS and CBSEM models estimates construct 
scores in the first stage, and uses them to produce a single-item product 
item for the interaction term in the second stage.
For a PLS model, the first stage uses PLS to compute construct scores. 
For a CBSEM model, the first stage uses a CFA to produce ten Berge 
construct scores.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3)),
  interaction_term(iv = "Image", moderator = "Expectation", method = two_stage)
)

#  structural model: note that name of the interactions construct should be
#  the names of its two main constructs joined by a '*' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image*Expectation"))
)

# PLS example:
mobi_pls <- estimate_pls(mobi, mobi_mm, mobi_sm)
summary(mobi_pls)

# CBSEM example:
mobi_cbsem <- estimate_cbsem(mobi, as.reflective(mobi_mm), mobi_sm)
summary(mobi_cbsem)

}
\references{
Henseler & Chin (2010), A comparison of approaches for the analysis of interaction effects
between latent variables using partial least squares path modeling. Structural Equation Modeling, 17(1),82-109.
}
