% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{corp_rep_data2}
\alias{corp_rep_data2}
\title{A Second Measurement Instrument for the Corporate Reputation Model}
\format{
A data frame with 347 rows and 49 variables:
\describe{
  \item{servicetype}{A categorical variable for the service type: 1=Postpaid plan; 2=Prepaid plan.}
  \item{serviceprovider}{A categorical variable for the service provider: 1, 2, 3, or 4.}
  \item{cusa}{If you consider your experiences with "company", how satisfied are you with "company"?}
  \item{cusl_1}{I would recommend "the company" to friends and relatives.}
  \item{cusl_2}{If I had to choose again, I would choose "the company" as my mobile phone services provider.}
  \item{cusl_3}{I will remain a customer of "the company" in the future.}
  \item{qual_1}{The products/services offered by "the company" are of high quality.}
  \item{qual_2}{"The company" is an innovator, rather than an imitator with respect to the mobile phone service industry.}
  \item{qual_3}{"The company's" services/products offer good quality for money.}
  \item{qual_4}{The services "the company" offers are good.}
  \item{qual_5}{Customer concerns are held in high regard at "the company".}
  \item{qual_6}{"The company" is a reliable partner for customers.}
  \item{qual_7}{"The company" is a trustworthy company.}
  \item{qual_8}{I have a lot of respect for "the company".}
  \item{perf_1}{"The company" is a very well managed company.}
  \item{perf_2}{"The company" is an economically stable company.}
  \item{perf_3}{The business risk of "the company" is reasonable compared to its competitors.}
  \item{perf_4}{The growth of "the company" is promising.}
  \item{perf_5}{"The company" has a clear vision about the future of the company.}
  \item{csor_1}{"The company" behaves in a socially conscious way.}
  \item{csor_2}{"The company" is honest in giving information to the public.}
  \item{csor_3}{"The company" competes fairly in the indsutry.}
  \item{csor_4}{"The company" cares for the preservation of the environment.}
  \item{csor_5}{"The company" is doing more than just making profits.}
  \item{attr_1}{"The company" is succesful in attracting high-quality employees.}
  \item{attr_2}{I could see myself working at "the company".}
  \item{attr_3}{I like the physical appearance of "the company" (company/buildings/shops, etc.).}
  \item{comp_1}{"The company" is a top competitor in its market.}
  \item{comp_2}{As far as I know, "the company" is recognized worldwide.}
  \item{comp_3}{I believe that "the company" performs at a premium level.}
  \item{like_1}{"The company" is a company that I can better identify with than other companies.}
  \item{like_2}{When comparing with other companies, "The company" is the company I would regret more if it no longer existed.}
  \item{like_3}{I regard "the company" as a likeable company.}
  \item{qual_global}{Please assess the general quality of "the company".}
  \item{perf_global}{Please assess the general performance of "the company".}
  \item{csor_global}{Please assess the extent to which "the company" acts in socially conscious ways.}
  \item{attr_global}{Please assess the attractiveness of "the company".}
  \item{switch_1}{It takes me a great deal of time to switch to another mobile phone services provider.}
  \item{switch_2}{It costs me too much to switch to another mobile phone services provider.}
  \item{switch_3}{It takes a lot of effort to get used to a new mobile phone services provider with its specific "rules" and practices.}
  \item{switch_4}{In general, it would be a hassle switching to another mobile phone services provider.}
}
}
\usage{
corp_rep_data2
}
\description{
The data set is used as measurement instrument for corporate reputation.
}
\details{
The data frame mobi contains the observed data for the model specified by Corporate Reputation.
}
\examples{
data("corp_rep_data2")

}
\references{
Sarstedt, M., Hair Jr, J. F., Cheah, J. H., Becker, J. M., & Ringle, C. M. (2019). How to specify, estimate, and validate higher-order constructs in PLS-SEM. Australasian Marketing Journal (AMJ), 27(3), 197-211.
}
\keyword{datasets}
