% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_bound_ur_i.R
\name{ci_bound_ur_i}
\alias{ci_bound_ur_i}
\title{Likelihood-Based Confidence
Bound By Root Finding}
\usage{
ci_bound_ur_i(
  i = NULL,
  npar = NULL,
  sem_out = NULL,
  f_constr = NULL,
  which = NULL,
  history = FALSE,
  perturbation_factor = 0.9,
  lb_var = -Inf,
  standardized = FALSE,
  wald_ci_start = !standardized,
  opts = list(),
  ciperc = 0.95,
  ci_limit_ratio_tol = 1.5,
  verbose = FALSE,
  sf = 1,
  sf2 = 0,
  p_tol = 5e-04,
  std_method = "internal",
  bounds = "none",
  xtol_rel_factor = 1,
  ftol_rel_factor = 1,
  lb_prop = 0.05,
  lb_se_k = 3,
  d = 5,
  ...
)
}
\arguments{
\item{i}{The position of the target
parameter as appeared in the
parameter table of a lavaan object,
generated by
\code{\link[lavaan:lavParTable]{lavaan::parameterTable()}}.}

\item{npar}{Ignored by this function.
Included consistency in the
interface.}

\item{sem_out}{The fit object.
Currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} objects only.}

\item{f_constr}{Ignored by this
function. Included consistency in the
interface.}

\item{which}{Whether the lower bound
or the upper bound is to be found.
Must be \code{"lbound"} or \code{"ubound"}.}

\item{history}{Not used. Kept for
backward compatibility.}

\item{perturbation_factor}{Ignored by
this function. Included consistency
in the interface.}

\item{lb_var}{Ignored by this
function. Included consistency in the
interface.}

\item{standardized}{If \code{TRUE}, the
LBCI is for the requested estimate in
the standardized solution. Default is
\code{FALSE}.}

\item{wald_ci_start}{Ignored by this
function. Included consistency in the
interface.}

\item{opts}{Options to be passed to
\code{\link[stats:uniroot]{stats::uniroot()}}. Default is
\code{list()}.}

\item{ciperc}{The intended coverage
probability for the confidence
interval. Default is .95, and the
bound for a 95\% confidence interval
will be sought.}

\item{ci_limit_ratio_tol}{The
tolerance for the ratio of \code{a} to
\code{b}, where \code{a} is the distance
between an LBCI limit and the point
estimate, and the \code{b} is the distance
between the original confidence limit
(by default the Wald CI in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}}) and the point
estimate. If the ratio is larger than
this value or smaller than the
reciprocal of this value, a warning
is set in the status code. Default is
1.5.}

\item{verbose}{If \code{TRUE}, the
function will store more diagnostic
information in the attribute \code{diag}.
Default is \code{FALSE}.}

\item{sf}{Ignored by this function.
Included consistency in the
interface.}

\item{sf2}{Ignored by this function.
Included consistency in the
interface.}

\item{p_tol}{Tolerance for checking
the achieved level of confidence. If
the absolute difference between the
achieved level and \code{ciperc} is
greater than this amount, a warning
is set in the status code and the
bound is set to \code{NA}. Default is
5e-4.}

\item{std_method}{The method used to
find the standardized solution. If
equal to \code{"lavaan"},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} will
be used. If equal to \code{"internal"}, an
internal function will be used. The
\code{"lavaan"} method should work in all
situations, but the \code{"internal"}
method is usually much faster.
Default is \code{"internal"}.}

\item{bounds}{Ignored by this
function. Included consistency in the
interface.}

\item{xtol_rel_factor}{Ignored by
this function. Included consistency
in the interface.}

\item{ftol_rel_factor}{Ignored by
this function. Included consistency
in the interface.}

\item{lb_prop}{Ignored by this
function. Included consistency in the
interface.}

\item{lb_se_k}{Ignored by this
function. Included consistency in the
interface.}

\item{d}{A value used to determine
the width of the interval in the
initial search. Larger this value,
\emph{narrow} the interval. Default is 5.
Used by \code{\link[=ci_bound_ur]{ci_bound_ur()}}.}

\item{...}{Optional arguments. Not
used.}
}
\value{
A \code{cibound}-class object
which is a list with three elements:
\itemize{
\item \code{bound}: A single number. The value
of the bound located. \code{NA} is the
search failed for various reasons.
\item \code{diag}: A list of diagnostic
information.
\item \code{call}: The original call.
}

A detailed and organized output can
be printed by the default print
method (\code{\link[=print.cibound]{print.cibound()}}).
}
\description{
Using root finding
to find the lower or
upper bound of the likelihood-based
confidence interval (LBCI) for one
parameter in a structural equation
model fitted in \code{\link[lavaan:lavaan]{lavaan::lavaan()}}.
}
\details{
\subsection{Important Notice}{

This function is not supposed to be
used directly by users in typical
scenarios. Its interface is
user-\emph{unfriendly} because it should
be used through \code{\link[=semlbci]{semlbci()}}. It is
exported such that interested users
can examine how a confidence bound is
found, or use it for experiments or
simulations.
}

\subsection{Usage}{

This function is the lowest level
function used by \code{\link[=semlbci]{semlbci()}}.
\code{\link[=semlbci]{semlbci()}} calls this function once
for each bound of each parameter.

For consistency in the interface,
most of the arguments in
\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} are also included
in this function, even those not used
internally.
}

\subsection{Algorithm}{

This function, unlike
\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}, use a simple root
finding algorithm. Basically, it tries
fixing the target parameter to
different values until the likelihood
ratio test \emph{p}-value, or the
corresponding chi-square difference,
is equal to the
value corresponding to the desired
level of confidence. (Internally,
the difference between the \emph{p}-value
and the target \emph{p}-value, that for
the chi-square difference, is the
function value.)

For finding the bound, this algorithm
can be inefficient compared to the
one proposed by Wu and Neale (2012).
The difference can be less than
one second versus 10 seconds.
It is included as a backup algorithm
for parameters which are difficult
for the method by Wu and Neale.

Internally, it uses \code{\link[=uniroot]{uniroot()}} to
find the root.
}

\subsection{Limitation(s)}{

This function does not handle an
estimate close to an attainable bound
using the method proposed by Wu and
Neale (2012). Use it for such
parameters with cautions.
}
}
\examples{

library(lavaan)
data(simple_med)
dat <- simple_med
mod <-
"
m ~ x
y ~ m
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)
# Remove `opts` in real cases.
# The options are added just to speed up the example
out1l <- ci_bound_ur_i(i = 1,
                       sem_out = fit_med,
                       which = "lbound",
                       opts = list(use_callr = FALSE,
                                   interval = c(0.8277, 0.8278)))
out1l
}
\references{
Wu, H., & Neale, M. C. (2012).
Adjusted confidence intervals for a
bounded parameter. \emph{Behavior
Genetics, 42}(6), 886-898.
\doi{10.1007/s10519-012-9560-z}
}
\seealso{
\code{\link[=print.cibound]{print.cibound()}},
\code{\link[=semlbci]{semlbci()}}, \code{\link[=ci_i_one]{ci_i_one()}}; see
\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} on the version
for the method by Wu and Neale
(2012).
}
