% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParDiffForest.R
\name{plotParDiffForest}
\alias{plotParDiffForest}
\title{Plot parameter differences}
\usage{
plotParDiffForest(
  forest,
  plot = "boxplot",
  measure = "wald",
  normalize = FALSE,
  predictors = NULL,
  title = TRUE
)
}
\arguments{
\item{forest}{a semforest object.}

\item{plot}{a character that specifies the plot typ. Available plot types
are "boxplot" (default) and "jitter" for a jittered strip plot with mean and
standard deviation.}

\item{measure}{a character. "wald" (default) gives the squared parameter
differences divided by their pooled standard errors. "test" gives the
contributions of the parameters to the test statistic. "raw" gives the
absolute values of the parameter differences.}

\item{normalize}{logical value; if TRUE parameter differences of each split
are divided by sum of all differences the corresponding split. Set to FALSE
by default.}

\item{predictors}{a character. Select predictors that are to be plotted.}

\item{title}{logical value; if TRUE a title is added to the plot.}
}
\description{
Visualizes parameter differences between post-split nodes in a
forest with boxplots.
}
\author{
Manuel Arnold
}
