% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs2rel.R
\name{abs2rel}
\alias{abs2rel}
\title{Convert a path to a relative path}
\usage{
abs2rel(path, ref_path, mustWork = NA)
}
\arguments{
\item{path}{The path to be converted (if it is not absolute,
the current working directory is considered as its parent, and a
warning is shown).}

\item{ref_path}{The reference path to be compared to
\code{path} to obtain the relative directory.
\emph{Important}: the path is considered as a directory
also if it is the path of a file!}

\item{mustWork}{(optional) logical: if TRUE an error is given
if \code{path} or \code{ref_path} do not exists; if NA (default) then a
warning; if FALSE nothing is shown.}
}
\value{
The relative path
}
\description{
The function convert an absolute path to a relative path
in respect to a reference. The longest common parent directory is
taken as reference. Symbolic links are converted to original paths
before performing the operation.
}
\note{
License: GPL 3.0
}
\examples{
# the reference path
(ref_path <- system.file(package="sen2r"))
# a path with a common parent with ref_path
(in_path_1 <- system.file(package="gdalUtils"))
# a path included in ref_path
(in_path_2 <- system.file("R/abs2rel.R", package="sen2r"))
# a path external to ref_path (in Linux)
(in_path_3 <- system.file(package="base"))
# an unexisting path
(in_path_4 <- gsub("sen2r","r2sen",ref_path))

abs2rel(in_path_1, ref_path)

abs2rel(in_path_2, ref_path)

suppressWarnings(abs2rel(in_path_3, ref_path))

suppressWarnings(abs2rel(in_path_4, ref_path, mustWork=FALSE))

suppressWarnings(abs2rel(ref_path, ref_path))
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2017) \email{luigi.ranghetti@gmail.com}
}
