% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gui_deps.R
\name{check_gui_deps}
\alias{check_gui_deps}
\title{Check GUI dependencies}
\usage{
check_gui_deps(abort = TRUE)
}
\arguments{
\item{abort}{Logical parameter: if TRUE (default), the function aborts in case
some packages need to be installed; if FALSE, a warning is shown.}
}
\value{
Logical (invisible): TRUE if all the required packages are installed,
FALSE (if \code{abort = FALSE}) or an error if some is missing.
}
\description{
Check if suggested dependencies required to run the
sen2r GUI are present.
}
\details{
Packages required to run the GUI (\strong{\code{shiny}}- and
\strong{\code{leaflet}}-related packages), which were \strong{\code{sen2r}} dependencies until
version 1.3.4, are now suggested dependencies.
\strong{\code{sen2r}} can be used without them with the exception of the GUI.
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
check_gui_deps()
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
