% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcindex.R
\name{calcindex_raster}
\alias{calcindex_raster}
\alias{calcindex_stars}
\title{Compute index using \code{raster} or \code{stars} features}
\usage{
calcindex_raster(
  x,
  sel_formula,
  out_file,
  NAflag = -32768,
  sel_format = "GTiff",
  compress = "LZW",
  datatype = "Int32",
  bigtiff = FALSE,
  overwrite = FALSE,
  minrows = NULL
)

calcindex_stars(
  x,
  sel_formula,
  out_file,
  NAflag = -32768,
  sel_format = "GTiff",
  compress = "LZW",
  datatype = "Int16",
  bigtiff = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{x}{Input file path, or \code{RasterLayer} (in \code{calcindex_raster()}) or
\code{stars} (in \code{calcindex_stars()}).}

\item{sel_formula}{Formula used to compute output raster
(specific formats are used - documentation will be improved).}

\item{out_file}{Output file path.}

\item{NAflag}{(optional)}

\item{sel_format}{(optional) Format of the output file (in a
format recognised by GDAL). Default "GTiff".}

\item{compress}{(optional) In the case a GTiff format is
present, the compression indicated with this parameter is used.}

\item{datatype}{(optional) Numeric datatype of the output rasters
(see \code{s2_calcindices()}).}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{overwrite}{Logical value: should existing output files be
overwritten? (default: FALSE)}

\item{minrows}{(optional) parameter passed to \code{blockSize()}.}
}
\value{
NULL (the function is called for its side effects)
}
\description{
Internal functions used to compute spectral indices and
thumbnails through \code{raster} or \code{stars} features.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
