% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovb_plots.R
\name{add_bound_to_contour}
\alias{add_bound_to_contour}
\alias{add_bound_to_contour.lm}
\alias{add_bound_to_contour.numeric}
\title{Add bounds to contour plot of omitted variable bias}
\usage{
add_bound_to_contour(...)

\method{add_bound_to_contour}{lm}(model, treatment, benchmark_covariates,
  kd = 1, ky = kd, reduce = TRUE, sensitivity.of = c("estimate",
  "t-value"), label.text = TRUE, cex.label.text = 1,
  label.bump.x = 0.02, label.bump.y = 0.02, round = 2, ...)

\method{add_bound_to_contour}{numeric}(r2dz.x, r2yz.dx,
  bound_value = NULL, bound_label = NULL, label.text = TRUE,
  cex.label.text = 1, label.bump.x = 0.02, label.bump.y = 0.02,
  round = 2, ...)
}
\arguments{
\item{...}{arguments passed to other methods.}

\item{model}{An \code{lm} object with the outcome regression.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{benchmark_covariates}{a character vector of the names of covariates that will be used to bound the plausible strength
of the unobserved confounders.}

\item{kd}{numeric vector. Parameterizes how many times stronger the confounder is related to the treatment in comparison to the observed benchmark covariate.
Default value is \code{1} (confounder is as strong as benchmark covariate).}

\item{ky}{numeric vector. Parameterizes how many times stronger the confounder is related to the outcome in comparison to the observed benchmark covariate.
Default value is the same as \code{kd}.}

\item{reduce}{Should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{sensitivity.of}{should the contour plot show adjusted estimates (\code{"estimate"})
or adjusted t-values (\code{"t-value"})?}

\item{label.text}{should label texts be plotted? Default is \code{TRUE}.}

\item{cex.label.text}{size of the label text.}

\item{label.bump.x}{bump on the x coordinate of label text.}

\item{label.bump.y}{bump on the y coordinate of label text.}

\item{round}{integer indicating the number of decimal places to be used for rounding.}

\item{r2dz.x}{Hypothetical partial R2 of unobserved confounder
Z with treatment D, given covariates X.}

\item{r2yz.dx}{Hypothetical partial R2 of unobserved confounder Z
with outcome Y, given covariates X and treatment D.}

\item{bound_value}{value to be printed in label bound.}

\item{bound_label}{label to bounds provided manually in \code{r2dz.x} and \code{r2yz.dx}.}
}
\value{
The function adds bounds in an existing contour plot and returns `NULL`.
}
\description{
Convenience function to add bounds on a sensitivity contour plot created with \code{\link{ovb_contour_plot}}.
}
\examples{

# runs regression model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
                         pastvoted + hhsize_darfur + female + village,
                         data = darfur)
# contour plot
ovb_contour_plot(model, treatment = "directlyharmed")

# add bound 3/1 times stronger than female
add_bound_to_contour(model,
                     treatment = "directlyharmed",
                     benchmark_covariates = "female",
                     kd = 3, ky = 1)

# add bound 50/2 times stronger than age
add_bound_to_contour(model,
                     treatment = "directlyharmed",
                     benchmark_covariates = "age",
                     kd = 50, ky = 2)

}
