% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.R
\name{sensi_plot}
\alias{sensi_plot}
\title{Graphical sensitivity analysis for comparative methods}
\usage{
sensi_plot(x, ...)
}
\arguments{
\item{x}{any output from the sensiPhy package.}

\item{...}{further arguments to methods}
}
\description{
Generic function for plotting results from
any sensitivity analysis performed with 'sensiPhy'
}
\details{
sensi_plot recognize and print different sets of graphs depending 
on the function that generated 'x'. See the links below for details about
the graphs generated for each sensiPhy function:
\itemize{
 \item{\code{\link[sensiPhy]{sensi_plot.sensiClade}}}
 \item{\code{\link[sensiPhy]{sensi_plot.sensiInflu}}}
 \item{\code{\link[sensiPhy]{sensi_plot.sensiSamp}}}
 \item{\code{\link[sensiPhy]{sensi_plot.sensiIntra}}}
 \item{\code{\link[sensiPhy]{sensi_plot.sensiTree}}}
 }
}
\author{
Gustavo Paterno
}
\references{
The function `multiplot`, developped by Winston Chang, is used inside sensi_plot
to print multiple graphs in one frame. 
The source code is available here:
\url{http://www.cookbook-r.com/Graphs/Multiple_graphs_on_one_page_(ggplot2)/}
}

