% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.effects.R
\name{calc.effects}
\alias{calc.effects}
\title{Function for estimation of natural direct and indirect effects and sensitivity analysis for unobserved mediator-outcome confounding}
\usage{
calc.effects(ML.object, type = "my", exp.name, med.name, covariates = NULL,
  alt.decomposition = FALSE, exp.value = 1, control.value = 0,
  med.model = NULL, out.model = NULL)
}
\arguments{
\item{ML.object}{object from \code{\link{coefs.sensmed}}}

\item{type}{the type of confounding for which the sensitivity analysis is to be performed. \code{type = "my"},  the default, corresponds to unobserved mediator-outcome
confounding,  \code{type = "zm"} to exposure-mediator confounding and \code{type = "zy"} to exposure-outcome confounding.}

\item{exp.name}{A character string indicating the name of the exposure variable used in the models.}

\item{med.name}{A character string indicating the name of the mediator used in the models.}

\item{covariates}{if conditional effects are to be estimated the list of covariate values. Covariates not specified are marginalized over. For more information, see \code{\link{sensmediation}}.}

\item{alt.decomposition}{logical indicating whether alternative definitions of the direct and indirect effects should be used (for more information, see \code{\link{sensmediation}}).}

\item{exp.value}{value of the exposure variable used as the exposure condition, default is 1.}

\item{control.value}{value of the exposure variable used as the control (unexposed) condition, default is 0.}

\item{med.model}{If \code{type = "zy"},  fitted \code{\link{glm}} model object representing the mediator model at the basis of the estimation.}

\item{out.model}{If \code{type = "zm"},  fitted \code{\link{glm}} model object representing the outcome model at the basis of the estimation.}
}
\value{
A list with elements:
\item{effects}{A list with elements \code{NIE} and \code{NDE},  row matrices with the estimated NIE and NDE (or NIE* and NDE* if \code{alt.decomposition = TRUE}) for each value of the sensitivity parameter \code{Rho}.}
\item{std.errs}{A list with elements \code{se.nie} and \code{se.nde},  row matrices with the estimated standard errors for the natural direct and indirect effects for the different values of the sensitivity parameter \code{Rho}.}
}
\description{
Function to estimate natural direct and indirect effect estimates and standard errors (using the delta method) based on parametric regression models and perform sensitivity analysis for unobserved confounding.
Intended to be called through \code{\link{sensmediation}} (or \code{\link{more.effects}}),  not on its own.
}
\seealso{
\code{\link{sensmediation}}
}
\author{
Anita Lindmark
}
