% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{read_word2vec}
\alias{read_word2vec}
\title{Read a word2vec embedding file}
\usage{
read_word2vec(
  x,
  type = c("txt", "bin"),
  n = .Machine$integer.max,
  encoding = "UTF-8",
  normalize = TRUE
)
}
\arguments{
\item{x}{path to the file}

\item{type}{either 'bin' or 'txt' indicating the \code{file} is a binary file or a text file}

\item{n}{integer, indicating to limit the number of words to read in. Defaults to reading all words.}

\item{encoding}{encoding to be assumed for the words. Defaults to 'UTF-8'}

\item{normalize}{logical indicating to normalize the embeddings by dividing by the factor (sqrt(sum(x . x) / length(x))). Defaults to TRUE.}
}
\value{
a matrix with one row per token containing the embedding of the token
}
\description{
Read a word2vec embedding file as a dense matrix. This uses \code{\link[word2vec]{read.wordvectors}} from the word2vec package.
}
\examples{
folder    <- system.file(package = "sentencepiece", "models")
embedding <- file.path(folder, "nl.wiki.bpe.vs1000.d25.w2v.bin")
embedding <- read_word2vec(embedding, type = "bin")
head(embedding)
embedding <- file.path(folder, "nl.wiki.bpe.vs1000.d25.w2v.txt")
embedding <- read_word2vec(embedding, type = "txt")
head(embedding, n = 10)
}
\seealso{
\code{\link[word2vec]{read.wordvectors}}
}
