% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stmtPlanner.R
\name{if_else_device}
\alias{if_else_device}
\title{Simulate a per-row block-\code{if(){}else{}}.}
\usage{
if_else_device(testexpr, thenexprs = NULL, elseexprs = NULL)
}
\arguments{
\item{testexpr}{character containing the test expression.}

\item{thenexprs}{named character then assignments (altering columns, not creating).}

\item{elseexprs}{named character else assignments (altering columns, not creating).}
}
\description{
This device uses expression-\code{ifelse(,,)} to simulate the
more powerful per-row block-\code{if(){}else{}}.  The difference is
expression-\code{ifelse(,,)} can choose per-row what value to express,
whereas block-\code{if(){}else{}} can choose per-row where to assign multiple
values. By simulation we mean: a sequence of quoted mutate expressions
are emitted that implement the transform (versus a using a custom
\code{dplyr} pipe stage or function).  These expressions can then
be optimized into a minimal number of no-dependency
blocks by \code{\link{partition_mutate_se}} for efficient execution.
The idea is the user can write legible code in this notation, and
the translation turns it into safe and efficient code suitable for
execution either on \code{data.frame}s or at a big data scale using
\code{RPostgreSQL} or \code{sparklyr}.
}
\details{
Note: \code{ifebtest_*}
is a reserved column name for this procedure.
}
\examples{

 # Example: clear one of a or b in any row where both are set.
 d <- data.frame(a = c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1),
                 b = c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1),
                 edited = FALSE)

 program <- if_else_device(
   testexpr = '(a+b)>1',
   thenexprs = c(
     if_else_device(
       testexpr = 'runif(n()) >= 0.5',
       thenexprs = 'a' := '0',
       elseexprs = 'b' := '0'),
     'edited' := 'TRUE'))
 print(program)

 plan <- partition_mutate_se(program)
 print(plan)

 res <- d \%.>\%
   mutate_seb(., plan) \%.>\%
   select_se(., grepdf('^ifebtest_.*', ., invert=TRUE))
 print(res)

 ## Note: with wrapr version 1.0.2 or greater
 ## you can write this without quotes code as:
 # program <- if_else_device(
 #  testexpr = qe((a+b)>1),
 #  thenexprs = c(
 #    if_else_device(
 #      testexpr = qe(runif(n()) >= 0.5),
 #      thenexprs = qae(a := 0),
 #      elseexprs = qae(b := 0)),
 #    qae(edited := TRUE)))

}
