% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_mmm.R
\name{build_mmm}
\alias{build_mmm}
\title{Build a Mixture Markov Model}
\usage{
build_mmm(observations, transition_probs, initial_probs, formula, data,
  coefficients, cluster_names = NULL)
}
\arguments{
\item{observations}{TraMineR stslist (see \code{\link[TraMineR]{seqdef}}) containing
the sequences.}

\item{transition_probs}{A list of matrices of transition
probabilities for submodels of each cluster.}

\item{initial_probs}{A list which contains vectors of initial state
probabilities for submodels of each cluster.}

\item{formula}{Covariates as an object of class \code{\link{formula}},
left side omitted.}

\item{data}{An optional data frame, list or environment containing the variables
in the model. If not found in data, the variables are taken from
\code{environment(formula)}.}

\item{coefficients}{An optional $k x l$ matrix of regression coefficients for time-constant
covariates for mixture probabilities, where $l$ is the number of clusters and $k$
is the number of covariates. A logit-link is used for mixture probabilities.
The first column is set to zero.}

\item{cluster_names}{A vector of optional names for the clusters.}
}
\value{
Object of class \code{mhmm} with following elements:
\describe{
   \item{\code{observations}}{State sequence object or a list of such containing the data.}
   \item{\code{transition_probs}}{A matrix of transition probabilities.}
   \item{\code{emission_probs}}{A matrix or a list of matrices of emission probabilities.}
   \item{\code{initial_probs}}{A vector of initial probabilities.}
   \item{\code{coefficients}}{A matrix of parameter coefficients for covariates (covariates in rows, clusters in columns).}
   \item{\code{X}}{Covariate values for each subject.}
   \item{\code{cluster_names}}{Names for clusters.}
   \item{\code{state_names}}{Names for hidden states.}
   \item{\code{symbol_names}}{Names for observed states.}
   \item{\code{channel_names}}{Names for channels of sequence data}
   \item{\code{length_of_sequences}}{(Maximum) length of sequences.}
   \item{\code{n_sequences}}{Number of sequences.}
   \item{\code{n_symbols}}{Number of observed states (in each channel).}
   \item{\code{n_states}}{Number of hidden states.}
   \item{\code{n_channels}}{Number of channels.}
   \item{\code{n_covariates}}{Number of covariates.}
   \item{\code{n_clusters}}{Number of clusters.}
}
}
\description{
Function \code{build_mmm} is a shortcut for constructing a mixture Markov
model as an restricted case of \code{mhmm} object.
}
\seealso{
\code{\link{fit_model}} for estimating model parameters;
\code{\link{summary.mhmm}} for a summary of a MHMM; \code{\link{separate_mhmm}} for
reorganizing a MHMM into a list of separate hidden Markov models; and
\code{\link{plot.mhmm}} for plotting \code{mhmm} objects.
}

