% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{D_optimal}
\alias{D_optimal}
\title{Get the most informative subjects for the clustered data}
\usage{
D_optimal(X, id, beta, nonZeroSet, M, rho, linkv, corstrv)
}
\arguments{
\item{X}{A data frame contains all the random samples which we will choose
subject from.}

\item{id}{The id for each subject in the X}

\item{beta}{The paramters that we estimate under the current samples}

\item{nonZeroSet}{The set of the index of the non zero coefficient}

\item{M}{A numeric matrix calculated by the \code{\link{getMH}} function}

\item{rho}{A numeric number indicating the estimate of correlation
coefficient}

\item{linkv}{A specification for the model link function.}

\item{corstrv}{A character string specifying the correlation structure. The
following are permitted: "independence", "exchangeable" and "ar1".}
}
\value{
a index of the most informative subject
}
\description{
Get the most informative subjects for the highly stratified
  response data by the D-optimility.
}
\details{
D_optimal uses the D-optimality criterion from the experimental design to
choose the most informative subjects for the highly stratified response
data.
}
