% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqTrans.R
\name{seqTrans}
\alias{seqTrans}
\title{Computing and spotting transitions among a dataset}
\usage{
seqTrans(OD, trans)
}
\arguments{
\item{OD}{\code{matrix} object containing sequences of a variable with missing data (coded as \code{NA}).}

\item{trans}{\code{character} vector gathering the impossible transitions. For example: trans <- c("1->3","1->4","2->1","4->1","4->3")}
}
\value{
It returns a matrix whose rows each are the indices of an impossible transition.
}
\description{
The purpose of \code{seqTrans.R} is to spot transitions
in a dataset.
}
\examples{
data(OD)

seqTransList <- seqTrans(OD=OD, trans=c("yes->no"))


}
\author{
Andre Berchtold <andre.berchtold@unil.ch>, Kevin Emery
}
