% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{SeqParSib}
\alias{SeqParSib}
\title{Fortran wrapper}
\usage{
SeqParSib(ParSib = "par", Specs = NULL, GenoM = NULL, LhIN = NULL,
  AgePriors = NULL, Parents = NULL, quiet = FALSE)
}
\arguments{
\item{ParSib}{either "par" to call parentage assignment, or "sib" to call
the rest of the algorithm.}

\item{Specs}{a named vector with parameter values, as generated by
\code{\link{SeqPrep}}.}

\item{GenoM}{matrix with genotype data, size nInd x nSnp}

\item{LhIN}{life history data: ID - sex - birth year}

\item{AgePriors}{matrix with agepriors, size Specs["nAgeClasses"] by 8.}

\item{Parents}{matrix with rownumbers of assigned parents, size nInd by 2}

\item{quiet}{suppress messages}
}
\value{
A list with
\item{PedigreePar or Pedigree}{the pedigree}
\item{MaybeParent or MaybeRel}{Non-assigned likely relatives}
\item{MaybeTrio}{Non-assigned parent-parent-offspring trios}
\item{DummyIDs}{Info on dummies}
\item{TotLikParents or TotLikSib}{Total log-likelihood per iteration}

For a detailed description of the output see \code{\link{sequoia}}
}
\description{
Call Fortran part and convert its output to a list with
dataframes.
}
\keyword{internal}
