% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ErrToM.R
\name{ErrToM}
\alias{ErrToM}
\title{Generate Genotyping Error Matrix}
\usage{
ErrToM(Err = NA, flavour = "version2.9", Return = "matrix")
}
\arguments{
\item{Err}{estimated genotyping error rate, as a single number, or 3x3 or 4x4
matrix, or length 3 vector. If a single number, an error model is used that
aims to deal with scoring errors typical for SNP arrays. If a matrix, this
should be the probability of observed genotype (columns) conditional on
actual genotype (rows). Each row must therefore sum to 1. If
\code{Return='function'}, this may be \code{NA}. If a vector, these are the
probabilities (observed given actual) hom|other hom, het|hom, and hom|het.}

\item{flavour}{vector-generating or matrix-generating function, or one of
'version2.9', 'version2.0', 'version1.3' (='SNPchip'), 'version1.1'
(='version111'), referring to the sequoia version in which it was used as
default. Only used if \code{Err} is a single number.}

\item{Return}{output, 'matrix' (default), 'vector', 'function'
(matrix-generating), or 'v_function' (vector-generating)}
}
\value{
Depending on \code{Return}, either:
 \itemize{
   \item \code{'matrix'}: a 3x3 matrix, with probabilities of observed genotypes
   (columns) conditional on actual (rows)
   \item \code{'function'}: a function taking a single value \code{Err} as input, and
   generating a 3x3 matrix
   \item \code{'vector'}: a length 3 vector, with the probabilities (observed given
     actual) hom|other hom, het|hom, and hom|het.
 }
}
\description{
Make a vector or matrix specifying the genotyping error
  pattern, or a function to generate such a vector/matrix from a single
  value Err.

with the probabilities of observed genotypes
  (columns) conditional on actual genotypes (rows), or return a function to
  generate such matrices (using a single value Err as input to that
 function).
}
\details{
By default (\code{flavour} = "version2.9"), \code{Err} is
  interpreted as a locus-level error rate (rather than allele-level), and
  equals the probability that an actual heterozygote is observed as either
  homozygote (i.e., the probability that it is observed as AA = probability
  that observed as aa = \code{Err}/2). The probability that one homozygote is
  observed as the other is (\code{Err}/2\eqn{)^2}.

The inbuilt 'flavours' correspond to the presumed and simulated error
structures, which have changed with sequoia versions. The most appropriate
error structure will depend on the genotyping platform; 'version0.9' and
'version1.1' were inspired by SNP array genotyping while 'version1.3' and
'version2.0' are intended to be more general.

This function, and throughout the package, it is assumed that the two alleles
\eqn{A} and \eqn{a} are equivalent. Thus, using notation \eqn{P}(observed
genotype |actual genotype), that \eqn{P(AA|aa) = P(aa|AA)},
\eqn{P(aa|Aa)=P(AA|Aa)}, and \eqn{P(aA|aa)=P(aA|AA)}.

\tabular{lccc}{
 \strong{version} \tab \strong{hom|hom} \tab \strong{het|hom} \tab
\strong{hom|het} \cr
 \strong{2.9}  \tab \eqn{(E/2)^2} \tab \eqn{E-(E/2)^2} \tab \eqn{E/2} \cr
 \strong{2.0}  \tab \eqn{(E/2)^2} \tab \eqn{E(1-E/2)}  \tab \eqn{E/2} \cr
 \strong{1.3}  \tab \eqn{(E/2)^2} \tab \eqn{E}   \tab \eqn{E/2} \cr
 \strong{1.1}  \tab \eqn{E/2}     \tab \eqn{E/2} \tab \eqn{E/2} \cr
 \strong{0.9}  \tab \eqn{0}       \tab \eqn{E}   \tab \eqn{E/2} \cr
}

or in matrix form, Pr(observed genotype (columns) | actual genotype (rows)):

\emph{version2.9:}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E} \tab \eqn{E -(E/2)^2} \tab \eqn{(E/2)^2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{(E/2)^2}   \tab \eqn{E -(E/2)^2} \tab \eqn{1-E} \cr
}

\emph{version2.0:}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{(1-E/2)^2} \tab \eqn{E(1-E/2)} \tab \eqn{(E/2)^2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{(E/2)^2}   \tab \eqn{E(1-E/2)} \tab \eqn{(1-E/2)^2} \cr
}

\emph{version1.3}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E-(E/2)^2} \tab \eqn{E} \tab \eqn{(E/2)^2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{(E/2)^2}   \tab \eqn{E} \tab \eqn{1-E-(E/2)^2} \cr
}

\emph{version1.1}
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E} \tab \eqn{E/2} \tab \eqn{E/2} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{E/2}   \tab \eqn{E/2} \tab \eqn{1-E} \cr
}

\emph{version0.9} (not recommended)
\tabular{lccc}{
    \tab \strong{0} \tab \strong{1} \tab \strong{2} \cr
 \strong{0}  \tab \eqn{1-E} \tab \eqn{E} \tab \eqn{0} \cr
 \strong{1}  \tab \eqn{E/2}       \tab \eqn{1-E}      \tab \eqn{E/2}    \cr
 \strong{2}  \tab \eqn{0}   \tab \eqn{E} \tab \eqn{1-E} \cr
}

When \code{Err} is a length 3 vector, or if \code{Return = 'vector'} these
 are the following probabilities:
\itemize{
 \item hom|hom: an actual homozygote is observed as the other homozygote
  (\eqn{E_1})
 \item het|hom: an actual homozygote is observed as heterozygote (\eqn{E_2})
 \item hom|het: an actual heterozygote is observed as homozygote (\eqn{E_3})
 }

 and Pr(observed genotype (columns) | actual genotype (rows)) is then:
\tabular{lccc}{
            \tab \strong{0}       \tab \strong{1}   \tab \strong{2}  \cr
 \strong{0} \tab \eqn{1-E_1-E_2} \tab \eqn{E_2}    \tab \eqn{E_1} \cr
 \strong{1} \tab \eqn{E_3}        \tab \eqn{1-2E_3} \tab \eqn{E_3}   \cr
 \strong{2} \tab \eqn{E_1}       \tab \eqn{E_2}    \tab \eqn{1-E_1-E_2} \cr
}

 When the SNPs are scored via sequencing (e.g. RADseq or DArTseq), the 3rd
 error rate (hom|het) is typically considerably higher than the other two,
 while for SNP arrays it tends to be similar to P(het|hom).
}
\examples{
ErM <- ErrToM(Err = 0.05)
ErM
ErrToM(ErM, Return = 'vector')


# use error matrix from Whalen, Gorjanc & Hickey 2018
funE <- function(E) {
 matrix(c(1-E*3/4, E/2, E/4,
          E/4, 1-2*E/4, E/4,
          E/4, E/2, 1-E*3/4),
          3,3, byrow=TRUE)  }
ErrToM(Err = 0.05, flavour = funE)
# equivalent to:
ErrToM(Err = c(0.05/4, 0.05/2, 0.05/4))

}
