% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Townships.R
\docType{data}
\name{Townships}
\alias{Townships}
\title{Bertin's Characteristics of Townships}
\format{
A matrix with 16 0-1 variables (columns) indicating the presence
(\code{1}) or absence (\code{0}) of characteristics of townships
(rows).
}
\description{
This data contains nine characteristics for 16 townships. The data
set was used by Bertin (1981) to illustrate that the conciseness
of presentation can be improved by seriating the rows and columns.
}
\examples{
data("Townships")

## original data
pimage(Townships)
criterion(Townships)


## seriated data
order <- seriate(Townships, method = "BEA", control = list(rep = 5))
pimage(Townships, order)
criterion(Townships, order)
}
\references{
\preformatted{Bertin, J. (1981): \\emph\{Graphics and Graphic Information Processing\}.
  Berlin, Walter de Gruyter.
}
}
\author{
Michael Hahsler
}
\keyword{datasets}
