% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA_registry_seriate.R
\docType{data}
\name{registry_seriate}
\alias{registry_seriate}
\alias{list_seriation_methods}
\alias{get_seriation_method}
\alias{set_seriation_method}
\alias{print.seriation_method}
\title{Registry for Seriation Methods}
\format{
An object of class \code{seriation_registry} (inherits from \code{registry}) of length 48.
}
\usage{
registry_seriate

list_seriation_methods(kind)

get_seriation_method(kind, name)

set_seriation_method(
  kind,
  name,
  definition,
  description = NULL,
  control = list(),
  ...
)

\method{print}{seriation_method}(x, ...)
}
\arguments{
\item{kind}{the data type the method works on. For example, \code{"dist"},
\code{"matrix"} or \code{"array"}. If missing, then methods for any type are
shown.}

\item{name}{the name for the method used to refer to the method in
\code{\link[=seriate]{seriate()}}.}

\item{definition}{a function containing the method's code.}

\item{description}{a description of the method. For example, a long name.}

\item{control}{a list with control arguments and default values.}

\item{...}{further information that is stored for the method in the
registry.}

\item{x}{an object of class  "seriation_method" to be printed.}
}
\value{
\itemize{
\item \code{list_seriation_method()} result is a vector of character strings with the
names of the methods. These names are used for methods in \code{seriate()}.
\item \code{get_seriation_method()} returns a given method in form of an object of class
\code{"seriation_method"}.
}
}
\description{
A registry to manage methods used by \code{\link[=seriate]{seriate()}}.
}
\details{
The functions below are convenience function for the registry
\code{registry_seriate}.

\code{list_seriation_method()} lists all available methods for a given data
type (\code{kind}) (e.g., "dist", "matrix").
The result is a vector of character strings with the
method names that can be used in function \code{seriate()}.
If \code{kind} is missing, then a list of
methods is returned.

\code{get_seriation_method()} returns detailed information for a given method in
form of an object of class \code{"seriation_method"}.
The information includes a description, parameters and the
implementing function.

With \code{set_seriation_method()} new seriation methods can be added by the
user. The implementing function (\code{definition}) needs to have the formal
arguments \code{x, control}, where \code{x} is the data object and
\code{control} contains a list with additional information for the method
passed on from \code{seriate()}.  The implementation has to return a list of
objects which can be coerced into \code{ser_permutation_vector} objects
(e.g., integer vectors). The elements in the list have to be in
corresponding order to the dimensions of \code{x}.
}
\examples{
# Registry
registry_seriate

# List all seriation methods by type
list_seriation_methods()

# List methods for matrix seriation
list_seriation_methods("matrix")

get_seriation_method(name = "BEA")

# Example for defining a new seriation method (reverse identity function for matrix)

# 1. Create the seriation method
seriation_method_reverse <- function(x, control) {
   # return a list of order vectors, one for each dimension
   list(seq(nrow(x), 1), seq(ncol(x), 1))
}

# 2. Register new method
set_seriation_method("matrix", "Reverse", seriation_method_reverse,
    description = "Reverse identity order", control = list())

list_seriation_methods("matrix")
get_seriation_method("matrix", "reverse")

# 3. Use the new seriation methods
seriate(matrix(1:12, ncol=3), "reverse")
}
\seealso{
This registry uses \code{\link[=registry]{registry()}} in package \pkg{registry}.

Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_tsne}()},
\code{\link{register_umap}()},
\code{\link{seriate}()}
}
\author{
Michael Hahsler
}
\concept{seriation}
\keyword{misc}
