% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAA_color_palette.R
\name{palette}
\alias{palette}
\alias{bluered}
\alias{palette,}
\alias{colors}
\alias{greenred}
\alias{reds}
\alias{blues}
\alias{greens}
\alias{greys}
\alias{grays}
\title{Different Useful Color Palettes}
\usage{
bluered(n = 100, bias = 1, power = 1, ...)

greenred(n = 100, bias = 1, power = 1, ...)

reds(n = 100, bias = 1, power = 1, ...)

blues(n = 100, bias = 1, power = 1, ...)

greens(n = 100, bias = 1, power = 1, ...)

greys(n = 100, bias = 1, power = 1, ...)

grays(n = 100, bias = 1, power = 1, ...)
}
\arguments{
\item{n}{number of different colors produces.}

\item{bias}{a positive number. Higher values give more widely spaced colors
at the high end.}

\item{power}{used to control how chroma and luminance is increased (1 =
linear, 2 = quadratic, etc.)}

\item{...}{further parameters are passed on to \code{\link[=sequential_hcl]{sequential_hcl()}}
or \code{\link[=diverging_hcl]{diverging_hcl()}}.}
}
\value{
A vector with \code{n} colors.
}
\description{
Defines several color palettes for \code{\link[=pimage]{pimage()}}, \code{\link[=dissplot]{dissplot()}} and
\code{\link[=hmap]{hmap()}}.
}
\details{
The color palettes are created with \code{\link[colorspace:hcl_palettes]{colorspace::sequential_hcl()}} and
\code{\link[colorspace:hcl_palettes]{colorspace::diverging_hcl()}}.

The two sequential palettes are: \code{reds()} and \code{grays()} (or
\code{greys()}).

The two diverging palettes are: \code{bluered()} and \code{greenred()}.
}
\examples{
m <- outer(1:10,1:10)
m

pimage(m)
pimage(m, col = greys(100, power = 2))
pimage(m, col = greys(100, bias = 2))
pimage(m, col = bluered(100))
pimage(m, col = bluered(100, power = .5))
pimage(m, col = bluered(100, bias = 2))
pimage(m - 25, col = greenred(20, bias = 2))

## choose your own color palettes
library(colorspace)
hcl_palettes(plot = TRUE)

## blues (with 20 shades)
pimage(m,
  col = colorspace::sequential_hcl(20, "Blues", rev = TRUE))
## blue to green (aka "Cork")
pimage(m,
  col = colorspace::diverging_hcl(100, "Cork"))
}
\seealso{
Other plots: 
\code{\link{VAT}()},
\code{\link{bertinplot}()},
\code{\link{dissplot}()},
\code{\link{hmap}()},
\code{\link{pimage}()}
}
\author{
Michael Hahsler
}
\concept{plots}
\keyword{hplot}
