% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domains_info}
\alias{sst_sa_domains_info}
\title{Domains summary}
\usage{
sst_sa_domains_info(
  api_token,
  domains,
  se,
  sort = NULL,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{domains}{(required) A vector of domain names to analyze.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns
  \href{https://serpstat.com/api/14-domain-summary-report-domaininfo/}{aggregated
  stats} for each domain.
}
\description{
Returns the number of keywords for each domain in SEO and
PPC, online visibility and other metrics.
}
\section{API rows consumption}{
 1 per domain in request.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\examples{
api_token <- 'api_token'
sst_sa_domains_info(
  api_token     = api_token,
  domains       = c('amazon.com', 'ebay.com'),
  se            = 'g_us',
  return_method = 'df'
)$data
}
