% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_database_info}
\alias{sst_sa_database_info}
\title{List all Serpstat databases}
\usage{
sst_sa_database_info(api_token, return_method = "list")
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns country name, se parameter value and local search engine
  domain name for each country.
}
\description{
In every request to get data from search analytics API you must set se
parameter to specify from what country do you want to get the data. This
method returns all acceptable values for se parameter with corresponding
country names.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/406-list-of-available-v4-databases-serpstatdatabaseproceduregetdatabaseinfo/}{here}.
}

\section{API rows consumption}{
 0
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_sa_database_info(api_token)$data
}
}
