% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domain_keywords}
\alias{sst_sa_domain_keywords}
\title{Domain organic keywords}
\usage{
sst_sa_domain_keywords(
  api_token,
  domain,
  se,
  url = NULL,
  keywords = NULL,
  minusKeywords = NULL,
  sort = NULL,
  filters = NULL,
  page = 1,
  size = 100,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{domain}{(required) Domain to get data for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{url}{(optional) Get the results for this URL only.}

\item{keywords}{(optional) A vector of words. Keywords in response will
contain these words}

\item{minusKeywords}{(optional) A vector of words. Keywords in response will
not contain these words.}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{filters}{(optional) A list of filtering options. See Filtering for more
details.}

\item{page}{(optional) Response page number if there are many pages in response.}

\item{size}{(optional) Response page size.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns a number of metrics for each keyword.
}
\description{
Returns up to 60 000 organic keywords from selected region for the domain
with a number of metrics for each keyword.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/584-top-search-engine-keywords-by-v4-domain-serpstatdomainproceduregetdomainkeywords/}{here}.
}

\section{API rows consumption}{
 1 per keyword in response.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\section{Filtering}{

  To filter the results you can use \code{filters} argument. It must be a
  list of named elements. The name of the element must match one of the
  filtering parameters. See API docs for more details. For example,
  \code{filters = list(queries_from = 0, queries_to = 10)} would narrow
  the results to include only the keywords that have a search volume
  between 0 and 10.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_sa_domain_keywords(
  api_token     = api_token,
  domain        = 'serpstat.com',
  se            = 'g_us',
  sort          = list(keyword_length = 'desc'),
  url           = 'https://serpstat.com/',
  keywords      = list('google'),
  minusKeywords = list('download'),
  filters       = list(queries_from = 0,
                       queries_to   = 10),
  page          = 2,
  size          = 10,
  return_method = 'df'
)$data
}
}
