% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set.R
\name{isSubset}
\alias{isSubset}
\alias{<.Set}
\alias{<=.Set}
\alias{>.Set}
\alias{>=.Set}
\title{Test If Two Sets Are Subsets}
\usage{
\method{<}{Set}(x, y)

\method{<=}{Set}(x, y)

\method{>}{Set}(x, y)

\method{>=}{Set}(x, y)
}
\arguments{
\item{x, y}{\link{Set}}
}
\value{
If \code{all} is \code{TRUE} then returns \code{TRUE} if all \code{x} are subsets of the Set, otherwise
\code{FALSE}. If \code{all} is \code{FALSE} then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\description{
Test If Two Sets Are Subsets
}
\details{
If using the method directly, and not via one of the operators then the additional boolean
argument \code{proper} can be used to specify testing of subsets or proper subsets. A Set is a proper
subset of another if it is fully contained by the other Set (i.e. not equal to) whereas a Set is a
(non-proper) subset if it is fully contained by, or equal to, the other Set.

When calling \link{isSubset} on objects inheriting from \link{Interval}, the method treats the interval as if
it is a \link{Set}, i.e. ordering and class are ignored. Use \link{isSubinterval} to test if one interval
is a subinterval of another.
}
\section{R6 Usage}{
 $isSubset(x, proper = FALSE, all = FALSE)
}

\examples{
Set$new(1,2,3)$isSubset(Set$new(1,2), proper = TRUE)
Set$new(1,2) < Set$new(1,2,3) # proper subset

c(Set$new(1,2,3), Set$new(1)) < Set$new(1,2,3) # not proper
Set$new(1,2,3) <= Set$new(1,2,3) # proper
}
\seealso{
\link{isSubinterval}

Other set methods: 
\code{\link{absComplement}},
\code{\link{contains}},
\code{\link{equals}}
}
\concept{set methods}
