% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testFuzzyTuple}
\alias{testFuzzyTuple}
\alias{checkFuzzyTuple}
\alias{assertFuzzyTuple}
\title{assert/check/test/FuzzyTuple}
\usage{
testFuzzyTuple(object, errormsg = "This is not an R6 FuzzyTuple object")

checkFuzzyTuple(object, errormsg = "This is not an R6 FuzzyTuple object")

assertFuzzyTuple(object, errormsg = "This is not an R6 FuzzyTuple object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{FuzzyTuple}.
}
\examples{
testFuzzyTuple(Set$new(2, 3))
testFuzzyTuple(list(Set$new(2), Set$new(3)))
testFuzzyTuple(Tuple$new(2, 3))
testFuzzyTuple(Interval$new())
testFuzzyTuple(FuzzySet$new(2, 0.1))
testFuzzyTuple(FuzzyTuple$new(2, 0.1))
testFuzzyTuple(ConditionalSet$new(function(x) x == 0))
}
