% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-upload.R
\name{Upload}
\alias{Upload}
\title{R6 Class representing an Upload job}
\description{
R6 Class representing a resource for managing files' uploads.
}
\examples{

## ------------------------------------------------
## Method `Upload$print`
## ------------------------------------------------

\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Print upload object information
 upload_object$print(name = name)
}


## ------------------------------------------------
## Method `Upload$init`
## ------------------------------------------------

\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Initialize multipart file upload object
 upload_object$init()
}

## ------------------------------------------------
## Method `Upload$info`
## ------------------------------------------------

\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Get upload job status information
 upload_object$info()
}

## ------------------------------------------------
## Method `Upload$start`
## ------------------------------------------------

\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Initialize multipart file upload object
 upload_object$init()

 # Start upload process
 upload_object$start()
}


## ------------------------------------------------
## Method `Upload$abort`
## ------------------------------------------------

\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Abort upload process
 upload_object$abort()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{upload_id}}{Upload ID received after upload initialization.}

\item{\code{path}}{Relative or absolute path to the file on the local disc.}

\item{\code{project}}{Project's identifier (character).}

\item{\code{parent}}{The ID of the folder to which the item is being uploaded.
Should not be used together with 'project'.}

\item{\code{filename}}{File name. By default it will be the same as the name of
the file you want to upload. However, it can be changed to new name.}

\item{\code{overwrite}}{If \code{TRUE} will overwrite file on the server.}

\item{\code{file_size}}{File size.}

\item{\code{part_size}}{Size of part in bytes.}

\item{\code{part_length}}{Number of parts to upload.}

\item{\code{parts}}{List of parts to be uploaded (class \code{Part}).}

\item{\code{initialized}}{If \code{TRUE}, upload has been initialized.}

\item{\code{auth}}{Authentication object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Upload-new}{\code{Upload$new()}}
\item \href{#method-Upload-print}{\code{Upload$print()}}
\item \href{#method-Upload-init}{\code{Upload$init()}}
\item \href{#method-Upload-info}{\code{Upload$info()}}
\item \href{#method-Upload-start}{\code{Upload$start()}}
\item \href{#method-Upload-abort}{\code{Upload$abort()}}
\item \href{#method-Upload-clone}{\code{Upload$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-new"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-new}{}}}
\subsection{Method \code{new()}}{
Create a new Upload object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$new(
  path = NA,
  project = NA,
  parent = NA,
  filename = NA,
  overwrite = FALSE,
  file_size = NA,
  part_size = getOption("sevenbridges2")$RECOMMENDED_PART_SIZE,
  initialized = FALSE,
  auth = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the file on the local disc.}

\item{\code{project}}{Project's identifier (character).}

\item{\code{parent}}{The ID of the folder to which the item is being uploaded.}

\item{\code{filename}}{New file name. Optional.}

\item{\code{overwrite}}{If true will overwrite file on the server.}

\item{\code{file_size}}{File size.}

\item{\code{part_size}}{Size of a single part in bytes.}

\item{\code{initialized}}{If \code{TRUE}, upload has been initialized.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-print"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-print}{}}}
\subsection{Method \code{print()}}{
Print method for Upload class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Print upload object information
 upload_object$print(name = name)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-init"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-init}{}}}
\subsection{Method \code{init()}}{
Initialize new multipart file upload.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$init()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Initialize multipart file upload object
 upload_object$init()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-info"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-info}{}}}
\subsection{Method \code{info()}}{
Get the details of an active multipart upload.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$info(list_parts = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{list_parts}}{If \code{TRUE}, also return a list of parts
that have been reported as completed for this multipart upload.
Please, bear in mind that the output could be heavy for printing if
there are lot of parts.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Get upload job status information
 upload_object$info()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-start"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-start}{}}}
\subsection{Method \code{start()}}{
Start the file upload
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$start()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{File}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Initialize multipart file upload object
 upload_object$init()

 # Start upload process
 upload_object$start()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-abort"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-abort}{}}}
\subsection{Method \code{abort()}}{
Abort the multipart upload
This call aborts an ongoing upload.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$abort()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_object <- Upload$new(
                    path = "path/to/my/file.txt",
                    project = project_object,
                    auth = auth
                   )

 # Abort upload process
 upload_object$abort()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Upload-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Upload-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Upload$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
