% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate.sf}
\alias{aggregate.sf}
\title{aggregate an \code{sf} object}
\usage{
\method{aggregate}{sf}(x, by, FUN, ..., union = FALSE)
}
\arguments{
\item{x}{object of class \link{sf}}

\item{by}{integer or \code{factor}, the same length as the number of rows in \code{x}, with groups to aggregate by (aggregation predicate)}

\item{FUN}{function passed on to \link[stats]{aggregate}, in case \code{ids} was specified and attributes need to be grouped}

\item{...}{arguments passed on to \code{FUN}}

\item{union}{logical; should grouped geometries be unioned using \link{st_union}?}
}
\value{
an \code{sf} object with aggregated attributes and geometries, with an additional grouping variable called \code{Group.1}.
}
\description{
aggregate an \code{sf} object, possibly union-ing geometries
}
