% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.R
\name{ic}
\alias{ic}
\alias{ic.sfacross}
\alias{ic.sfalcmcross}
\alias{ic.sfaselectioncross}
\title{Extract information criteria of stochastic frontier models}
\usage{
\method{ic}{sfacross}(object, IC = "AIC", ...)

\method{ic}{sfalcmcross}(object, IC = "AIC", ...)

\method{ic}{sfaselectioncross}(object, IC = "AIC", ...)
}
\arguments{
\item{object}{A stochastic frontier model returned
by \code{\link{sfacross}}, \code{\link{sfalcmcross}}, or
\code{\link{sfaselectioncross}}.}

\item{IC}{Character string. Information criterion measure. Three criteria
are available: \itemize{ \item \code{'AIC'} for Akaike information criterion
(default) \item \code{'BIC'} for Bayesian information criterion \item
\code{'HQIC'} for Hannan-Quinn information criterion }.}

\item{...}{Currently ignored.}
}
\value{
\code{\link{ic}} returns the value of the information criterion
(AIC, BIC or HQIC) of the maximum likelihood coefficients.
}
\description{
\code{\link{ic}} returns information criterion from stochastic
frontier models estimated with \code{\link{sfacross}}, \code{\link{sfalcmcross}},
or \code{\link{sfaselectioncross}}.
}
\details{
The different information criteria are computed as follows: \itemize{ \item
AIC: \eqn{-2 \log{LL} + 2 * K} \item BIC: \eqn{-2 \log{LL} + \log{N} * K}
\item HQIC: \eqn{-2 \log{LL} + 2 \log{\left[\log{N}\right]} * K} } where
\eqn{LL} is the maximum likelihood value, \eqn{K} the number of parameters
estimated and \eqn{N} the number of observations.
}
\examples{

\dontrun{
## Using data on Swiss railway
# LCM (cost function) half normal distribution
cb_2c_u <- sfalcmcross(formula = LNCT ~ LNQ2 + LNQ3 + LNNET + LNPK + LNPL,
udist = 'hnormal', uhet = ~ 1, data = swissrailways, S = -1, method='ucminf')
ic(cb_2c_u)
ic(cb_2c_u, IC = 'BIC')
ic(cb_2c_u, IC = 'HQIC')
}

}
\seealso{
\code{\link{sfacross}}, for the stochastic frontier analysis model
fitting function using cross-sectional or pooled data.

\code{\link{sfalcmcross}}, for the latent class stochastic frontier analysis
model fitting function using cross-sectional or pooled data.

\code{\link{sfaselectioncross}} for sample selection in stochastic frontier
model fitting function using cross-sectional or pooled data.
}
\keyword{AIC}
\keyword{BIC}
\keyword{HQIC}
\keyword{methods}
