% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals}
\alias{residuals}
\alias{residuals.sfacross}
\alias{residuals.sfalcmcross}
\alias{residuals.sfaselectioncross}
\title{Extract residuals of stochastic frontier models}
\usage{
\method{residuals}{sfacross}(object, ...)

\method{residuals}{sfalcmcross}(object, ...)

\method{residuals}{sfaselectioncross}(object, ...)
}
\arguments{
\item{object}{A stochastic frontier model returned
by \code{\link{sfacross}}, \code{\link{sfalcmcross}}, or
\code{\link{sfaselectioncross}}.}

\item{\dots}{Currently ignored.}
}
\value{
When the \code{object} is of class \code{'sfacross'}, or
\code{'sfaselectioncross'}, \code{\link{residuals}} returns a vector of
residuals values.

When the \code{object} is of \code{'sfalcmcross'},
\code{\link{residuals}} returns a data frame containing the residuals values
for each latent class, where each variable ends with \code{'_c#'},
\code{'#'} being the class number.
}
\description{
This function returns the residuals' values from stochastic frontier models
estimated with \code{\link{sfacross}}, \code{\link{sfalcmcross}}, or
\code{\link{sfaselectioncross}}.
}
\note{
The residuals values are ordered in the same way as the corresponding
observations in the dataset used for the estimation.
}
\examples{

\dontrun{
## Using data on fossil fuel fired steam electric power generation plants in the U.S.
# Translog SFA (cost function) truncated normal with scaling property
tl_u_ts <- sfacross(formula = log(tc/wf) ~ log(y) + I(1/2 * (log(y))^2) +
log(wl/wf) + log(wk/wf) + I(1/2 * (log(wl/wf))^2) + I(1/2 * (log(wk/wf))^2) +
I(log(wl/wf) * log(wk/wf)) + I(log(y) * log(wl/wf)) + I(log(y) * log(wk/wf)),
udist = 'tnormal', muhet = ~ regu, uhet = ~ regu, data = utility, S = -1,
scaling = TRUE, method = 'mla')
resid.tl_u_ts <- residuals(tl_u_ts)
head(resid.tl_u_ts)

## Using data on eighty-two countries production (GDP)
# LCM Cobb Douglas (production function) half normal distribution
cb_2c_h <- sfalcmcross(formula = ly ~ lk + ll + yr, udist = 'hnormal', 
data = worldprod, S = 1)
resid.cb_2c_h <- residuals(cb_2c_h)
head(resid.cb_2c_h)
}

}
\seealso{
\code{\link{sfacross}}, for the stochastic frontier analysis model
fitting function using cross-sectional or pooled data.

\code{\link{sfalcmcross}}, for the latent class stochastic frontier analysis
model fitting function using cross-sectional or pooled data.

\code{\link{sfaselectioncross}} for sample selection in stochastic frontier
model fitting function using cross-sectional or pooled data.
}
\keyword{methods}
\keyword{residuals}
