% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{st_lag}
\alias{st_lag}
\title{Calculate spatial lag}
\usage{
st_lag(x, nb, wt, na_ok = FALSE, allow_zero = NULL, ...)
}
\arguments{
\item{x}{A numeric vector}

\item{nb}{A neighbor list object as created by \code{st_neighbors()}.}

\item{wt}{A weights list as created by \code{st_weights()}.}

\item{na_ok}{Default \code{FALSE}. If, \code{TRUE} missing values return a lagged \code{NA}.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{See \code{?spdep::lag.listw} for more.}
}
\value{
a numeric vector with same length as \code{x}
}
\description{
Calculates the spatial lag of a numeric variable given a neighbor and weights list.
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wt <- st_weights(nb)

st_lag(guerry$crime_pers, nb, wt)
}
\seealso{
Other stats: 
\code{\link{local_moran}()}
}
\concept{stats}
