% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_linestring}
\alias{sf_linestring}
\title{sf LINESTRING}
\usage{
sf_linestring(obj = NULL, x = NULL, y = NULL, z = NULL, m = NULL,
  linestring_id = NULL, keep = FALSE)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{linestring_id}{column of ids for linestrings}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}
}
\value{
\code{sf} object of LINESTRING geometries
}
\description{
constructs sf of LINESTRING objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain the first row of any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\examples{

x <- matrix( c(1:4), ncol = 2 )
sf_linestring( x )

x <- data.frame( id = 1:2, x = 1:2, y = 2:1 )
sf_linestring( x )
sf_linestring( x, x = "x", y = "y" )
sf_linestring( x, x = "y", y = "x" )
sf_linestring( x, linestring_id = "id", x = "x", y = "y")

}
