% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_helpers.R
\name{sf_mline}
\alias{sf_mline}
\title{Helper for sf MULTILINESTRING}
\usage{
sf_mline(obj, keep = FALSE, list_columns = NULL)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}

\item{list_columns}{vector of column names to turn into a list.}
}
\value{
\code{sf} object of MULTILINESTRING geometries
}
\description{
Constructs sf of MULTILINESTRING objects, a helper for \code{\link[=sf_multilinestring]{sf_multilinestring()}}
with a simpler syntax.
}
\section{Helpers}{

These are simpler versions of the main functions \code{\link[=sf_point]{sf_point()}},
\code{\link[=sf_multipoint]{sf_multipoint()}}, \code{\link[=sf_linestring]{sf_linestring()}}, \code{\link[=sf_multilinestring]{sf_multilinestring()}}, \code{\link[=sf_polygon]{sf_polygon()}},
and \code{\link[=sf_multipolygon]{sf_multipolygon()}} for input data frame or matrix that contains columns
appropriately of 'x', 'y', 'z', 'm', ' multipolygon_id', polygon_id',
'multilinestring_id', 'linestring_id', 'multipoint_id'.

This puts the onus of the naming and identification of entities onto the
input data set, rather than when calling the creator function. This has pros
and cons, so is not necessarily always 'simpler'. Please choose the
appropriate constructor for the context you have. For examples a data frame
from the real world with columns 'lon', 'lat', 'line' will be best used with

\code{sf_linestring(df, x = "lon", y = "lat", linestring_id = "line")}

whereas a heavy user of sfheaders might always create a data frame with 'x',
'y', 'linestring_id' precisely because they are expecting to call
\code{sf_line(df)} and no further work is required. These are very different
contexts and both equally valid.

Some columns are mandatory, such as 'x' and 'y' (always), while others depend
on the output type where each column for that type is mandatory. The 'z'
and/or 'm' values are included for 'XYZ', 'XYM', or 'XYZM' geometry types if
and as they are present.

In summary these helpers:
\itemize{
\item do not require arguments declaring column names.
\item use assumed default column names, with no variation or absence allowed for
a given type.
\item use \code{z}, and/or \code{m} if present.
\item use \code{close = FALSE} and \code{keep = FALSE} same as proper constructors.
\item unlike \code{\link[=sf_point]{sf_point()}} \code{\link[=sf_pt]{sf_pt()}} does not accept a flat vector for a single
point.
\item require a matrix or data frame with complete column names.
}

None of the helpers allow partial name matching for column names.
}

\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

You can use \code{list_columns} to specify which of the properties will be turned into
a list, thus keeping all the values in the column. For columns not specified in \code{list_columns},
only the first row of the column is kept

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\examples{

m <- cbind(x = 0, y = 0, multilinestring_id = c(1, 1, 1), linestring_id = 1)
sf_mline( m )

df <- data.frame(
  multilinestring_id = c(1,1,1,1,1,1,1,1,2,2,2,2,2)
  ,    linestring_id = c(1,1,1,2,2,3,3,3,1,1,1,2,2)
  , x = rnorm(13)
  , y = rnorm(13)
  , z = rnorm(13)
  , m = rnorm(13)
)

sf_mline( obj = df)
sf_mline( obj = df[-6])
## this gives XYZ, not XYM see #64
(sfx <- sf_mline( obj = df[-5]))

## we trivially round-trip with sf_mline()
sf_mline(sf_to_df(sfx))

## to round-trip with all fields use `fill`, then `keep`
sf_mline(sf_to_df(sfx, fill = TRUE), keep = TRUE)

}
