% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infomeasures.R
\name{infomeasures}
\alias{infomeasures}
\title{Tool to calculate information measures in the original scale of the response variable, such as, AIC and BIC.}
\usage{
infomeasures(fit)
}
\arguments{
\item{fit}{an object of the class sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg() function.}
}
\description{
\code{infomesuares} is used to calculate the information measures in the original scale for a generalized log-gamma regression model.
}
\examples{
rows  <- 240
columns <- 3
t_beta  <- c(0.7, 0.5, 2)
t_sigma <- 1.5
t_lambda <- sigma
set.seed(8142031)
library(ssym)
x2 <- rbinom(rows, 1, 0.5)
x3 <- runif(rows, 0, 1)
X <- cbind(1,x2,x3)
s         <- t_sigma^2
a         <- 1/s
t_ini1    <- exp(X \%*\% t_beta) * rgamma(rows, scale = s, shape = a)
cens.time <- rweibull(rows, 0.4, 14)
delta1     <- ifelse(t_ini1 > cens.time, 1, 0)
obst1 <- t_ini1
for (i in 1:rows) {
if (delta1[i] == 1) {
   obst1[i] <- cens.time[i]
  }
}
data.example <- data.frame(obst1,delta1,X)
fit3 <- survglg(Surv(log(obst1),delta1) ~ x2 + x3 , data=data.example,shape=1)
infomeasures(fit3)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>, G. Paula and L. Vanegas.
}
