% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.npc.R
\name{plotnpc}
\alias{plotnpc}
\title{Plotting a natural cubic splines or P-splines.}
\usage{
plotnpc(fit, conf_lev)
}
\arguments{
\item{fit}{an object of the class sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg().}

\item{conf_lev}{is the confidence level of the asymptotic confidence band. Default value is 0.05.}
}
\description{
\code{plotnpc} displays a graph of a fitted nonparametric effect, either natural cubic spline or P-spline, from an object of class sglg.
}
\examples{
library(sglg)
library(ssym)
library(ggplot2)
set.seed(1)
n <- 200
error <- rglg(n,0,1,1)
t <- as.matrix((2*1:n - 1)/(2*n))
colnames(t) <- "t"
f_t <- cos(4*pi*t)
y <- 0.5 + f_t + error
colnames(y) <- "y"
data <- as.data.frame(cbind(y,1,t))
fit1 <- sglg(y ~ 1,npc=t,data=data,basis = "deBoor",alpha0=seq(0.001,0.005,by=0.001),nknts=5)
quantile_residuals(fit1)
# The adjusted (black) and true (red) non-linear component
plotnpc(fit1) + geom_line(aes(t,f_t),colour="red")
fit2 <- sglg(y ~ 1,npc=t,data=data,basis = "Gu",alpha0=seq(0.001,0.005,by=0.001),nknts=9)
quantile_residuals(fit2)
# The adjusted (black) and true (red) non-linear component
plotnpc(fit2,conf_lev=0.01) + geom_line(aes(t,f_t),colour="red",size=1.2)
}
\references{
Eilers P.H.C. and Marx B.D. (1996). Flexible smoothing with B-splines and penalties. Statistical Science. 11, 89-121.

Wood, S. (2006). Additive generalized models: An R introduction. Chapman and Hall.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>, G. Paula and L. Vanegas.
}
